#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>
#include <fstream>
#include <random>
#include <stack>
#include <set>
using namespace std;


std::vector<std::vector<bool>> visited;
//std::vector<std::vector<char>> arr;
// age, pos
#define xy std::pair<long long, long long>
#define fire std::pair<int, xy>
#define fireQueue std::priority_queue<fire, std::vector<fire>, std::greater<fire>>

int res = 0;

void iterateFire(fireQueue& queue) {
    if (queue.empty()) return;
    int currAge = queue.top().first;
    while (!queue.empty() && queue.top().first == currAge) {
        xy pos = queue.top().second;
        int di[] = { -1, 0, 0, 1 };
        int dj[] = { 0, 1, -1, 0 };
        queue.pop();
        for (int k = 0; k < 4; k++) {
            int i = di[k] + pos.first;
            int j = dj[k] + pos.second;
            if (i >= 0 && i < visited.size() && j >= 0 && j < visited[0].size()) {
                if (!visited[i][j]) {
                    queue.push({ currAge + 1, {i, j} });
                    visited[i][j] = true;
                }
            }
        }
    }
}

std::set<xy> hull;
int orientation(xy p1, xy p2, xy p) {
    int val = (p.second - p1.second) * (p2.first - p1.first) - (p2.second - p1.second) * (p.first - p1.first);
    if (val > 0) return 1;
    if (val < 0) return -1;
    return 0;
}

long long distance(xy p1, xy p2, xy p) {
    return abs((p.second - p1.second) * (p2.first - p1.first) - (p2.second - p1.second) * (p.first - p1.first));
}
double distance(xy p1, xy p2) {
    return sqrt((p1.second - p2.second) * (p1.second - p2.second) - (p1.first - p2.first) * (p1.first - p2.first));
}

double heronov(xy p1, xy p2, xy p3) {
    double d1 = distance(p1, p2);
    double d2 = distance(p2, p3);
    double d3 = distance(p1, p3);
    double s = d1 + d2 + d3;
    return sqrt(s * (s - d1) * (s - d2) * (s - d3));
}

/*double pov(std::vector<xy> a) {
    for (int i = 0; i <)
}*/

void quick(std::vector<xy> a, xy p1, xy p2, int side) {
    int index = -1;
    long long max = 0;

    for (int i = 0; i < a.size(); i++) {
        long long curr = distance(p1, p2, a[i]);
        if (orientation(p1, p2, a[i]) == side && curr > max) {
            index = i;
            max = curr;
        }
    }

    if (index == -1) {
        hull.insert(p1);
        hull.insert(p2);
    }
    else {
        quick(a, a[index], p1, -orientation(a[index], p1, p2));
        quick(a, a[index], p2, -orientation(a[index], p2, p1));
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    std::cout.tie(NULL);

    /*int t;
    std::cin >> t;
    for (int iter = 0; iter < t; iter++) {
        long long l, r, k;
        std::cin >> l >> r >> k;
        
        long long p = r / k;
        long long res = (p - l + 1);
        if (res < 0) res = 0;
        std::cout << res << std::endl;
        
    }*/

    int n;
    std::cin >> n;
    std::vector<xy> arr;

    for (int i = 0; i < n; i++) {
        long long y, x;
        std::cin >> x >> y;
        arr.push_back({ x, y });
    }

    long long res = LLONG_MAX;

    for (int i = 0; i < n; i++) {
        std::vector<xy> a(arr);
        a.erase(a.begin() + i);

        long long minx = 0, maxx = 0;
        for (int i = 1; i < a.size(); i++) {
            if (a[i].first < a[minx].first) minx = i;
            if (a[i].first > a[maxx].first) maxx = i;
        }

        quick(a, a[minx], a[maxx], 1);
        quick(a, a[minx], a[maxx], -1);
        std::vector<xy> vertices;
        while (!hull.empty()) {
            vertices.push_back({(*hull.begin()).first, (*hull.begin()).second });
            hull.erase(hull.begin());
        }
        //std::cout << std::endl;
        long long area = 0;
        int i1 = vertices.size() - 1;
        for (int i = 0; i < vertices.size(); i++) {
            area += (vertices[i1].first + vertices[i].first) * (vertices[i1].second - vertices[i].second) / 2;
            i1 = i;
        }
        area = abs(area);
        if ((long long)area < res) res = area;
    }

    std::cout << res << std::endl;

    return 0;
}